spool create_WS_HUC_ORG_SUMMARY.log

drop TABLE WS_HUC_ORG_SUMMARY  ;
CREATE TABLE WS_HUC_ORG_SUMMARY  
(HYDROLOGIC_UNIT_CODE		  VARCHAR2(12 CHAR) NOT NULL, 
 ORGANIZATION_ID  		  VARCHAR2(256 BYTE) NOT NULL, 
 ORGANIZATION_NAME		  VARCHAR2 (256 BYTE), 
 MIN_ACTIVITY_START_DATE_TIME	  DATE, 
 MAX_ACTIVITY_STOP_DATE_TIME	  DATE, 
 STATION_COUNT	  		  NUMBER(12), 
 RESULT_COUNT			  NUMBER(12), 
 CHARACTERISTIC_COUNT		  NUMBER(12))  
tablespace storetdata  
storage(initial 5M next 5M)
nologging;


ALTER TABLE WS_HUC_ORG_SUMMARY 
ADD CONSTRAINT PK_WS_HUC_ORG_SUMMARY  
PRIMARY KEY  (ORGANIZATION_ID, HYDROLOGIC_UNIT_CODE)  
using index  
tablespace storetindx  
storage (initial 2M next 2M);

comment on table WS_HUC_ORG_SUMMARY is 'Watershed Hydrologic Oganization Summary table.' ;
comment on column WS_HUC_ORG_SUMMARY.HYDROLOGIC_UNIT_CODE is 'Hydrologic Unit code' ;
comment on column WS_HUC_ORG_SUMMARY.ORGANIZATION_ID is 'Organization Identifier' ;
comment on column WS_HUC_ORG_SUMMARY.ORGANIZATION_NAME is 'Organization Name' ;
comment on column WS_HUC_ORG_SUMMARY.MIN_ACTIVITY_START_DATE_TIME is 'Minimum Activity Start Date Time' ;
comment on column WS_HUC_ORG_SUMMARY.MAX_ACTIVITY_STOP_DATE_TIME is 'Maximum Acitvity Stop Date Time' ;
comment on column WS_HUC_ORG_SUMMARY.STATION_COUNT is 'Station count' ;
comment on column WS_HUC_ORG_SUMMARY.RESULT_COUNT is 'Results count' ;
comment on column WS_HUC_ORG_SUMMARY.CHARACTERISTIC_COUNT is 'Characteristic Count' ;



create or replace PROCEDURE  SP_REFRESH_WS_HUC_ORG_SUMMARY AS
cursor station_data_cur is
SELECT hydrologic_unit_code, organization_id,
		organization_name,
		min(min_activity_start_date_time) AS min_activity_start_date_time,
		max(max_activity_stop_date_time) AS max_activity_stop_date_time,
		count(DISTINCT unique_station_identifier) AS station_count,
		sum(char_result_count) AS result_count,
		count(DISTINCT CHARACTERISTIC_ID) AS characteristic_count
FROM WS_STATION_DATA
WHERE hydrologic_unit_code is NOT NULL
GROUP BY hydrologic_unit_code, organization_id, organization_name;

  v_huc									varchar2(12 char);
  v_organization_id						varchar2(256 byte);
  v_org_name							varchar2(256 byte);
  v_min_act_start_date					date;
  v_max_act_stop_date					date;
  v_station_count						number(12);
  v_result_count						number(12);
  v_characteristic_count				number(12);
  v_insert_count						number(12);
  v_create_stmt							varchar2(800 char);
  v_insert_stmt							varchar2(800 char);

begin

--create ws_huc_org_summary
dbms_output.put_line('Creating ws_huc_org_summary table ...');


begin
execute immediate 'drop index IWS_HO_HUC';
exception when others then Null;
end;

begin
execute immediate 'drop index IWS_HO_HUC_ORGID';
exception when others then Null;
end;

begin
  execute immediate 'truncate table WS_HUC_ORG_SUMMARY';
exception when others then
  null;
end;

--grants
begin
dbms_output.put_line('Granting select to storetweb on ws_huc_org_summary ...');
execute immediate 'grant select on WS_HUC_ORG_SUMMARY to storetweb';
exception when others then null;
end;

-- populate while comitting after every 1000 insertions
dbms_output.put_line('Populating ws_huc_org_summary table ...');
v_insert_count := 0;
open station_data_cur;
loop
	fetch station_data_cur into
  		  v_huc, v_organization_id, v_org_name,
  		  v_min_act_start_date, v_max_act_stop_date,
  		  v_station_count, v_result_count,
  		  v_characteristic_count;
	exit when station_data_cur%NOTFOUND;

	insert into ws_huc_org_summary
  	(hydrologic_unit_code, organization_id,
 	organization_name, min_activity_start_date_time,
	max_activity_stop_date_time, station_count,
	result_count, characteristic_count)
 	values
  	(v_huc, v_organization_id ,
	v_org_name, v_min_act_start_date,
	v_max_act_stop_date, v_station_count,
	v_result_count, v_characteristic_count);

	v_insert_count := v_insert_count + 1;
	if (v_insert_count=1000) then
		   v_insert_count := 0;
		   commit;
	end if;
end loop;
close station_data_cur;
commit;

--create indexes on ws_huc_org_summary
dbms_output.put_line('Creating indexes on ws_huc_org_summary table ...');
begin
execute immediate 'CREATE INDEX IWS_HO_HUC ON WS_HUC_ORG_SUMMARY ' ||
'(TRIM(HYDROLOGIC_UNIT_CODE)) ' ||
'tablespace storetindx ' ||
'storage (initial 4M next 2M)';
exception when others then null;
end;

begin
execute immediate 'CREATE INDEX IWS_HO_HUC_ORGID ON WS_HUC_ORG_SUMMARY ' ||
'(TRIM(HYDROLOGIC_UNIT_CODE), LOWER(TRIM(ORGANIZATION_ID))) ' ||
'tablespace storetindx ' ||
'storage (initial 4M next 2M)';
exception when others then null;
end;

BEGIN
execute immediate 'ANALYZE TABLE WS_HUC_ORG_SUMMARY COMPUTE STATISTICS  FOR TABLE FOR ALL INDEXES';
exception when others then null;
end;


end;
/
show errors;

select count(*) from WS_HUC_ORG_SUMMARY;
set serveroutput on size 60000;
  exec SP_REFRESH_WS_HUC_ORG_SUMMARY;
select count(*) from WS_HUC_ORG_SUMMARY;
spool off;